<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User\Block;

use Erlage\Photogram\System;
use Erlage\Photogram\Data\Tables\User\UserBlockTable;
use Erlage\Photogram\Data\Models\InterfaceModelBuilder;

final class UserBlockBuilder implements InterfaceUserBlockSetter, InterfaceModelBuilder
{
    /**
     * setter interface
     */
    use TraitUserBlockSetters;

    /*
    |--------------------------------------------------------------------------
    | default values
    |--------------------------------------------------------------------------
    */

    /**
     * @var array
     */
    public $defaultValues;

    public function __construct()
    {
        $this -> defaultValues = self::defaultValues();
    }

    public static function defaultValues(): array
    {
        return array(
            UserBlockTable::BLOCKED_USER_ID    => '',
            UserBlockTable::BLOCKED_BY_USER_ID => '',

            UserBlockTable::STAMP_REGISTRATION => System::isoDateTime(),
            UserBlockTable::STAMP_LAST_UPDATE  => System::isoDateTime(),
        );
    }

    public function dispense(): UserBlockModel
    {
        return UserBlockModel::createFromData(
            array(
                // blocked user id

                UserBlockTable::BLOCKED_USER_ID => $this -> blockedUserId

                ?? $this -> defaultValues[UserBlockTable::BLOCKED_USER_ID],

                // blocked by user id

                UserBlockTable::BLOCKED_BY_USER_ID => $this -> blockedByUserId

                ?? $this -> defaultValues[UserBlockTable::BLOCKED_BY_USER_ID],

                // stamp registration

                UserBlockTable::STAMP_REGISTRATION => $this -> stampRegistration

                ?? $this -> defaultValues[UserBlockTable::STAMP_REGISTRATION],

                // stamp last update

                UserBlockTable::STAMP_LAST_UPDATE => $this -> stampLastUpdate

                ?? $this -> defaultValues[UserBlockTable::STAMP_LAST_UPDATE],
            )
        );
    }
}
